<?php
/*
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

More about this license: LICENCE.html
 */

if (!defined('QA_VERSION')) {
	// don't allow this page to be requested directly from browser
	header('Location: ../');
	exit;
}

require_once QA_INCLUDE_DIR.'king-app/format.php';
require_once QA_INCLUDE_DIR.'king-app/limits.php';
require_once QA_INCLUDE_DIR.'king-db/selects.php';
require_once QA_INCLUDE_DIR.'king-util/sort.php';
require_once QA_INCLUDE_DIR.'king-db/metas.php';
require_once QA_INCLUDE_DIR.'king-app/posts.php';
//    Check whether this is a follow-on question and get some info we need from the database

$in = array();

$followpostid     = qa_get('follow');
$in['categoryid'] = qa_clicked('doask') ? qa_get_category_field_value('category') : qa_get('cat');
$userid           = qa_get_logged_in_userid();
$handle           = qa_get_logged_in_handle();

list($categories, $followanswer, $completetags) = qa_db_select_with_pending(
	qa_db_category_nav_selectspec($in['categoryid'], true),
	isset($followpostid) ? qa_db_full_post_selectspec($userid, $followpostid) : null,
	qa_db_popular_tags_selectspec(0, QA_DB_RETRIEVE_COMPLETE_TAGS)
);

if (!isset($categories[$in['categoryid']])) {
	$in['categoryid'] = null;
}

if (@$followanswer['basetype'] != 'A') {
	$followanswer = null;
}

//    Check for permission error

$permiterror = qa_user_maximum_permit_error('permit_post_q', QA_LIMIT_QUESTIONS);

if ($permiterror && qa_clicked('doask')) {
	$errors = array();
	$errors['permiterror'] = qa_lang_html('question/ask_limit');
	$response['status'] = 'error';
	$response['message'] = $errors;
	echo json_encode($response); // Output response as JSON
	exit;
}

if ($permiterror || ! qa_opt('enable_aivideo')) {
	$qa_content = qa_content_prepare();

	switch ($permiterror) {
		case 'login':
		$qa_content['error']=qa_lang_html('users/no_permission');
		$econtent = qa_insert_login_links(qa_lang_html('question/ask_must_login'), qa_request(), isset($followpostid) ? array('follow' => $followpostid) : null);
		break;

		case 'confirm':
		$qa_content['error']=qa_lang_html('users/no_permission');
		$econtent = qa_insert_login_links(qa_lang_html('question/ask_must_confirm'), qa_request(), isset($followpostid) ? array('follow' => $followpostid) : null);
		break;

		case 'limit':
		$qa_content['error']=qa_lang_html('users/no_permission');
		$econtent=qa_lang_html('question/ask_limit');
		break;

		case 'membership':
		$qa_content['error']=qa_lang_html('users/no_permission');
		$econtent=qa_insert_login_links(qa_lang_html('misc/mem_message'));
		$qa_content['custom'] = '<div class="nopost"><i class="fa-solid fa-fingerprint fa-4x"></i><p>'.$econtent.'</p><a href="'. qa_path_html( 'membership' ) .'" class="meme-button">'.qa_lang_html('misc/see_plans').'</a></div>';
		break;

		case 'approve':
		$qa_content['error']=qa_lang_html('users/no_permission');
		$econtent=qa_lang_html('question/ask_must_be_approved');
		break;

		default:
		$econtent=qa_lang_html('users/no_permission');
		$qa_content['error']=qa_lang_html('users/no_permission');
		break;
	}

	if (empty($qa_content['custom'] )) {
		$qa_content['custom'] = '<div class="nopost"><i class="fa-solid fa-circle-user fa-4x"></i>'.$econtent.'</div>';
	}
	return $qa_content;
}


$captchareason = qa_user_captcha_reason();

$in['title'] = qa_get_post_title('title'); // allow title and tags to be posted by an external form


if (qa_using_tags()) {
	$in['tags'] = qa_get_tags_field_value('tags');
}

if (qa_clicked('doask')) {
    require_once QA_INCLUDE_DIR . 'king-app/post-create.php';
	require_once QA_INCLUDE_DIR . 'king-app/post-update.php';
    require_once QA_INCLUDE_DIR . 'king-util/string.php';
	$in['postid'] = qa_post_text('uniqueid');
	$post=qa_db_select_with_pending(qa_db_full_post_selectspec($userid, $in['postid']));
    $categoryids = array_keys(qa_category_path($categories, @$in['categoryid']));
    $userlevel   = qa_user_level_for_categories($categoryids);

    $in['nsfw']   = qa_post_text('nsfw');
    $in['prvt']   = qa_post_text('prvt');
	qa_get_post_content('editor', 'content', $in['editor'], $in['content'], $in['format'], $in['text']);

	$errors = array();
    if (!qa_check_form_security_code('ask', qa_post_text('code'))) {
        $errors['page'] = qa_lang_html('misc/form_security_again');
    } else {
        $filtermodules = qa_load_modules_with('filter', 'filter_question');
        foreach ($filtermodules as $filtermodule) {
            $oldin = $in;
            $filtermodule->filter_question($in, $errors, null);
            qa_update_post_text($in, $oldin);
        }

        if (qa_using_categories() && count($categories) && (!qa_opt('allow_no_category')) && !isset($in['categoryid'])) {
            $errors['categoryid'] = qa_lang_html('question/category_required');
        } elseif (qa_user_permit_error('permit_post_q', null, $userlevel)) {
            $errors['categoryid'] = qa_lang_html('question/category_ask_not_allowed');
        }

        if ($captchareason) {
            require_once QA_INCLUDE_DIR . 'king-app/captcha.php';
            qa_captcha_validate_post($errors);
        }

		if ( isset( $errors['title'] ) ) {
			$errors['title'] = qa_lang_html('main/title_field');
		}

        if (empty($errors)) {
            $cookieid = isset($userid) ? qa_cookie_get() : qa_cookie_get_create(); // create a new cookie if necessary

			king_update_ai_post($in['postid'], $in['title'], isset($in['tags']) ? qa_tags_to_tagstring($in['tags']) : '', $in['nsfw'], 'V');

			$answers         = qa_post_get_question_answers( $in['postid'] );
			$commentsfollows = qa_post_get_question_commentsfollows( $in['postid'] );
			$closepost       = qa_post_get_question_closepost( $in['postid'] );

			if ( qa_using_categories() && isset($in['categoryid']) ){
				qa_question_set_category( $post, $in['categoryid'], $userid, $handle, $cookieid,
					$answers, $commentsfollows, $closepost, false );
			}
            if (isset($in['prvt'])) {
                qa_post_set_hidden($in['postid'], true, null);
            }
            $response['status'] = 'success';
            $response['message'] = qa_lang_html('misc/published');
			$response['url'] = qa_q_request($in['postid'], $in['title']);
			$response['message2'] = qa_lang_html('misc/seep');
        } else {
            $response['status'] = 'error';
            $response['message'] = $errors;
        }
        echo json_encode($response); // Output response as JSON
        exit;
    }
}
	if (qa_is_logged_in() && ( qa_opt('ailimits') || qa_opt('ulimits') ) && qa_get_logged_in_level() <= QA_USER_LEVEL_ADMIN && qa_opt('enable_membership')) {
		$qa_content = qa_content_prepare();
		$mp  = qa_db_usermeta_get( $userid, 'membership_plan' );
		$pl = null;
		if ($mp) {
			$pl = (INT)qa_opt('plan_'.$mp.'_lmt');
		} elseif(qa_opt('ulimits')) {
			$pl = (INT)qa_opt('ulimit');
		}
		$alm = (INT)qa_db_usermeta_get( $userid, 'ailmt' );
		if ($alm >= $pl) {
			$qa_content['custom'] = '<div class="nopost"><i class="fa-solid fa-circle-user fa-4x"></i>'.qa_lang('misc/nocredits').'<p><a href="'.qa_path_html('membership').'">'.qa_lang('misc/buycredits').'</a></p></div>';
			return $qa_content;
		}
	}
//    Prepare content for theme

$qa_content = qa_content_prepare(false, array_keys(qa_category_path($categories, @$in['categoryid'])));

$qa_content['title'] = qa_lang_html('misc/king_aivid');
$qa_content['error'] = @$errors['page'];


$field['label'] = qa_lang_html('question/q_content_label');
$field['error'] = qa_html(@$errors['content']);

$custom = qa_opt('show_custom_ask') ? trim(qa_opt('custom_ask')) : '';


if (qa_is_logged_in()) {

$cont = '';
if ( qa_opt( 'king_leo_enable' ) && qa_opt( 'enable_aivideo' ) ) {
	$cont .= '<ul class="king-nav-kingsub-list" id="nav-kingsub">';
	if ( qa_opt( 'king_leo_enable' ) ) {
		$cont .='<li class="king-nav-kingsub-item">';
		$cont .='<a href="' . qa_path_html( 'submitai' ) . '" ><i class="fa-solid fa-panorama"></i> ' . qa_lang_html( 'misc/king_ai' ) . '</a>';
		$cont .='</li>';
	}
	if ( qa_opt( 'enable_aivideo' ) ) {
		$cont .='<li class="king-nav-kingsub-item">';
		$cont .='<a href="' . qa_path_html( 'videoai' ) . '" class="king-nav-kingsub-selected"><i class="fa-regular fa-circle-play"></i> ' . qa_lang_html( 'misc/king_aivid' ) . '</a>';
		$cont .='</li>';
	}
	$cont .='</ul>';
}

$cont .= '<div class="kingai-box active">
<div class="king-form-tall-error" id="ai-error" style="display: none;"></div>';
if ($custom) {
$cont .= '<div class="snote" >'.$custom.'</div>';
}
$cont .= '<div class="kingai-input">
			<textarea type="textarea" id="ai-box" class="aiinput" oninput="adjustHeight(this)" placeholder="'.qa_lang('misc/dvideo').'" maxlength="600" autocomplete="off" style="height: 44px;" rows="1"></textarea>';
$cont .= '<div class="kingai-down">';
// Define available models and their options
$models = array(
	'wan' => array(
		'enabled' => qa_opt('enable_wan'),
		'label' => 'Wan 2',
	),
	'luma' => array(
		'enabled' => qa_opt('enable_luna'),
		'label' => 'Luma Ray',
	),
	'pixverse' => array(
		'enabled' => qa_opt('enable_pixverse'),
		'label' => 'Pixverse',
	),	
	'veo' => array(
		'enabled' => false,
		'label' => 'Veo 3',
	),
	'see' => array(
		'enabled' => qa_opt('enable_see'),
		'label' => 'Seedance',
	),
	'veo3' => array(
		'enabled' => qa_opt('enable_veo3'),
		'label' => 'Veo 3',
	),
	'veo3f' => array(
		'enabled' => qa_opt('enable_veo3f'),
		'label' => 'Veo 3 Fast',
	),
);

// Define enabled status variables for each model
$luna_enabled = !empty($models['luma']['enabled']);
$pixverse_enabled = !empty($models['pixverse']['enabled']);
$wan_enabled = !empty($models['wan']['enabled']);
$veo_enabled = !empty($models['veo']['enabled']);
$see_enabled = !empty($models['see']['enabled']);
$veo3_enabled = !empty($models['veo3']['enabled']);
$veo3f_enabled = !empty($models['veo3f']['enabled']);

// Filter enabled models
$enabled_models = array_filter($models, function($model) {
	return !empty($model['enabled']);
});

$model_count = count($enabled_models);
$hide_model = ($model_count <= 1) ? ' hide' : '';

// Set default model (first enabled one)
$default_key = key($enabled_models);
$default_model = $default_value = '';
if ($enabled_models) {
	$first = reset($enabled_models);
	$default_model = $first['label'];
	$default_value = $default_key;
}

// Determine the model class if only one model is enabled
if ($model_count == 1) {
	$cmodel = $default_value;
} else {
	$cmodel = '';
}
$cont .= '<div class="' . qa_html($default_value) . '" id="chclass">';
$cont .= '<div class="kingai-downleft kingai-buttons">';
if ( qa_opt( 'enable_luna_img')) {
$cont .= '<div id="newsthumb" class="dropzone king-poll-file aiupload dhpix hveo"></div>';
}


$cont .= '<div class="king-dropdownup custom-select model-select' . qa_html($hide_model) . '">
	<div class="king-sbutton kings-button" id="model-select-btn" data-toggle="dropdown" aria-expanded="false" role="button">
		<span id="model-select-label">' . qa_html($default_model) . '</span>
	</div>
	<div class="king-dropdownc king-dropleft model-options">';
if ($wan_enabled) {
	$checked = ($default_value == 'wan') ? 'checked' : '';
	$cont .= '<label class="cradio">
		<input type="radio" name="aimodel" value="wan" ' . $checked . '>
		<span>Wan 2</span>
	</label>';
}	
if ($luna_enabled) {
	$checked = ($default_value == 'luma') ? 'checked' : '';
	$cont .= '<label class="cradio">
		<input type="radio" name="aimodel" value="luma" ' . $checked . '>
		<span>Luma Ray</span>
	</label>';
}
if ($pixverse_enabled) {
	$checked = ($default_value == 'pixverse') ? 'checked' : '';
	$cont .= '<label class="cradio">
		<input type="radio" name="aimodel" value="pixverse" ' . $checked . '>
		<span>Pixverse</span>
	</label>';
}

if ($veo_enabled) {
	$checked = ($default_value == 'veo') ? 'checked' : '';
	$cont .= '<label class="cradio">
		<input type="radio" name="aimodel" value="veo" ' . $checked . '>
		<span>Veo 3</span>
	</label>';
}
if ($see_enabled) {
	$checked = ($default_value == 'see') ? 'checked' : '';
	$cont .= '<label class="cradio">
		<input type="radio" name="aimodel" value="see" ' . $checked . '>
		<span>Seedance</span>
	</label>';
}
if ($veo3_enabled) {
	$checked = ($default_value == 'veo3') ? 'checked' : '';
	$cont .= '<label class="cradio">
		<input type="radio" name="aimodel" value="veo3" ' . $checked . '>
		<span>Veo 3</span>
	</label>';
}
if ($veo3f_enabled) {
	$checked = ($default_value == 'veo3f') ? 'checked' : '';
	$cont .= '<label class="cradio">
		<input type="radio" name="aimodel" value="veo3f" ' . $checked . '>
		<span>Veo 3 Fast</span>
	</label>';
}
$cont .= '</div>';
$cont .= '</div>';



$cont .= '<div class="king-dropdownup custom-select hveo">
							<div class="king-sbutton kings-button" id="aivsizeb" data-toggle="dropdown" aria-expanded="false" role="button">16:9</div>
							<div class="king-dropdownc king-dropleft aivsize">                   
								<label class="cradio"><input type="radio" name="aisize" value="16:9" id="aivsize" checked class="hide"><span><i class="king-square s1"></i>16:9</span></label>
								<label class="cradio hwan"><input type="radio" name="aisize" value="4:3" class="hide"><span><i class="king-square s2"></i>4:3</span></label>
								<label class="cradio hwan dhpix"><input type="radio" name="aisize" value="1:1" class="hide"><span><i class="king-square"></i>1:1</span></label>
								<label class="cradio hwan"><input type="radio" name="aisize" value="3:4" class="hide"><span><i class="king-square s4"></i>3:4</span></label>
								<label class="cradio"><input type="radio" name="aisize" value="9:16" class="hide"><span><i class="king-square s5"></i>9:16</span></label>
							</div>
						</div>';

$cont .= '<div class="king-dropdownup custom-select video-reso-select dhpix hveo">
	<div class="king-sbutton kings-button" id="video-reso-btn" data-toggle="dropdown" aria-expanded="false" role="button">
		<span id="video-reso-label">540p</span>
	</div>
	<div class="king-dropdownc king-dropleft video-reso-options">
		<label class="cradio">
			<input type="radio" name="reso" value="540p" checked onchange="document.getElementById(\'video-reso-label\').innerText=\'540p\'">
			<span>540p</span>
		</label>
		<label class="cradio">
			<input type="radio" name="reso" value="720p" onchange="document.getElementById(\'video-reso-label\').innerText=\'720p\'">
			<span>720p</span>
		</label>
	</div>
</div>';
$cont .= '</div>';
$cont .= '</div>';
$cont .= '<div class="kingai-buttons">';
if (qa_opt('eprompter')) {
    $showElement = qa_opt('oaprompter') ? (qa_get_logged_in_level() >= QA_USER_LEVEL_ADMIN) : true;
    
    if ($showElement) {
        $cont .= '<button type="button" id="prompter" onclick="aipromter(this)" class="king-sbutton ai-create promter" data-toggle="tooltip" title="' . qa_lang('misc/prompter') . '" data-placement="left"><i class="fa-solid fa-feather"></i><div class="loader"></div></button>';
    }
}
$cont .= '<button type="button" id="ai-submit" class="ai-submit" onclick="return videogenerate(this);">
<span><i class="fa-solid fa-paper-plane"></i> '.qa_lang('misc/generate').'</span><div class="loader"></div></button>';
$cont .= '</div>';
$cont .= '</div>';
	$cont .= '</div>';

$cont .= '<div id="ai-results">'.king_ai_posts($userid, 'aivid').'</div>';
$cont .= '</div>';
$qa_content['custom'] = $cont;	
$qa_content['form'] = array(
	'tags'    => 'name="ask" method="post" action="' . qa_self_html() . '" id="ai-form"',

	'style'   => 'tall',

	'fields'  => array(
		'close'    => array(
			'type' => 'custom',
			'html' => '<span onclick="aipublish(this)" class="aisclose"><i class="fa-solid fa-xmark"></i></span>',
		),
		'errorc'    => array(
			'type' => 'custom',
			'html' => '<div id="error-container"></div>',
		),		
		
		'title'     => array(
			'label' => qa_lang_html('question/q_title_label'),
			'tags'  => 'name="title" id="title" autocomplete="off" minlength="'.qa_opt('min_len_q_title').'"  required',
			'value' => qa_html(@$in['title']),
			'error' => qa_html(@$errors['title']),
		),

		'similar'   => array(
			'type' => 'custom',
			'html' => '<span id="similar"></span>',
		),
		'uniqueid'  => array(
			'label' => '',
			'tags'  => 'name="uniqueid" id="uniqueid" class="hide"',
		),


	),

	'buttons' => array(
		'ask' => array(
			'tags'  => 'onclick="submitAiform(event);" id="submitButton"',
			'label' => qa_lang_html('question/ask_button'),
		),
	),

	'hidden'  => array(
		'code'   => qa_get_form_security_code('ask'),
		'doask'  => '1',
	),
);

script_options($qa_content);
if (!strlen($custom)) {
	unset($qa_content['form']['fields']['custom']);
}

if (qa_opt('do_ask_check_qs') || qa_opt('do_example_tags')) {
	$qa_content['script_rel'][] = 'king-content/king-ask.js?' . QA_VERSION;
	$qa_content['form']['fields']['title']['tags'] .= ' onchange="qa_title_change(this.value);"';

	if (strlen(@$in['title'])) {
		$qa_content['script_onloads'][] = 'qa_title_change(' . qa_js($in['title']) . ');';
		

	}

}
$qa_content['script_var']['leoai']=qa_path('submitai_ajax');


if (isset($followanswer)) {
	$viewer = qa_load_viewer($followanswer['content'], $followanswer['format']);

	$field = array(
		'type'  => 'static',
		'label' => qa_lang_html('question/ask_follow_from_a'),
		'value' => $viewer->get_html($followanswer['content'], $followanswer['format'], array('blockwordspreg' => qa_get_block_words_preg())),
	);

	qa_array_insert($qa_content['form']['fields'], 'title', array('follows' => $field));
}

if (qa_using_categories() && count($categories)) {
	$field = array(
		'label' => qa_lang_html('question/q_category_label'),
		'error' => qa_html(@$errors['categoryid']),
	);

	qa_set_up_category_field($qa_content, $field, 'category', $categories, $in['categoryid'], true, qa_opt('allow_no_sub_category'));

	if (!qa_opt('allow_no_category')) // don't auto-select a category even though one is required
	{
		$field['options'][''] = '';
	}

	qa_array_insert($qa_content['form']['fields'], 'similar', array('category' => $field));
}


if (qa_using_tags()) {
	$field = array(
		'error' => qa_html(@$errors['tags']),
	);



	qa_set_up_tag_field($qa_content, $field, 'tags', isset($in['tags']) ? $in['tags'] : array(), array(),
		qa_opt('do_complete_tags') ? array_keys($completetags) : array(), qa_opt('page_size_ask_tags'));

	qa_array_insert($qa_content['form']['fields'], null, array('tags' => $field));

}


if ( qa_opt('enable_nsfw') || qa_opt('enable_pposts') ) {
	$nsfw = '';
	$prvt = '';
	if ( qa_opt('enable_pposts') ) {
		$prvt = '<input name="prvt" id="king_prvt" type="checkbox" class="hide" value="'.qa_html(@$in['prvt']).'"><label for="king_prvt" class="king-nsfw"><i class="fa-solid fa-user-ninja"></i> '.qa_lang('misc/prvt').'</label>';
	}
	if ( qa_opt('enable_nsfw') ) {
		$nsfw = '<input name="nsfw" id="king_nsfw" type="checkbox" value="'.qa_html(@$in['nsfw']).'"><label for="king_nsfw" class="king-nsfw">'.qa_lang_html('misc/nsfw').'</label>';
	}
	$field = array(
		'type' => 'custom',
		'html' => ''.$prvt.$nsfw.''
	);
	qa_array_insert($qa_content['form']['fields'], null, array('nsfw' => $field));
}

if (!isset($userid)) {
	qa_set_up_name_field($qa_content, $qa_content['form']['fields'], @$in['name']);
}


if ($captchareason) {
	require_once QA_INCLUDE_DIR . 'king-app/captcha.php';
	qa_set_up_captcha_field($qa_content, $qa_content['form']['fields'], @$errors, qa_captcha_reason_note($captchareason));
}

} else {
	$cont2  = '<div class="kingai-input">';
	$cont2 .= '<textarea type="textarea" id="ai-box" class="aiinput" data-toggle="modal" data-target="#loginmodal" placeholder="'.qa_lang('misc/aiplace').'" maxlength="600" autocomplete="off" style="height: 44px;" rows="1"></textarea>';
	$cont2 .= '<div class="kingai-buttons">';

	$cont2 .= '<button type="button" id="ai-submit" class="ai-submit" data-toggle="modal" data-target="#loginmodal">
<span><i class="fa-solid fa-paper-plane"></i> '.qa_lang('misc/generate').'</span><div class="loader"></div></button>';
	$cont2 .= '</div>';
	$cont2 .= '</div>';
	$qa_content['custom'] = $cont2;

}
$qa_content['class']=' ai-create';
$qa_content['focusid'] = 'ai-box';

return $qa_content;
/*
Omit PHP closing tag to help avoid accidental output
 */
